<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => false,
        'name' => 'pages',
        'title' => [
            'fr' => 'Pages',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'type' => BridgeContentType::IMAGE_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Image',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => $weight++,
            ],
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'type' => BridgeContentType::SECTION_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Contenu',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => $weight++,
            ],
            'settings' => [
                'target_type' => ['text', 'text_with_image', 'image', 'file', 'video', 'map', 'html', 'accordion', 'call_to_action', 'files', 'slider'],
                'cardinality' => -1,
            ],
        ],
    ],
];
