<?php

use Illuminate\Support\Str;

return [
    'postfilter' => function ($users) {
        return $users
            ->filter(
                fn ($user) =>
                $user->accountEnabled &&
                !blank($user->mail) &&
                !blank($user->companyName) &&
                !str($user->displayName)->startsWith('ARCH_') &&
                !str($user->mail)->contains([
                    '.onmicrosoft.com',
                    '@azurinfo.fr',
                    '@old.groupeprotech.fr',
                    '@orange.fr',
                    '@hoopiz.fr',
                    '@allianz-trade.com',
                    '@lagardere-le.com',
                    '@natheia-consulting.fr',
                    '@parteam.fr',
                    '@qualix.fr',
                    '@winpub.fr',
                    '@arenaaix.com',
                ])
            )->map(function ($user) {
                $user->domains = str($user->mail)->after('@')->toString();
                $user->brands = Str::beforeLast($user->domains, '.');

                return $user;
            });
    },
    'sync_attributes' => [
        'name' => 'mail',
        'mail' => 'mail',
        'firstname' => 'givenName',
        'lastname' => 'surname',
        'function' => 'jobTitle',
        'phone' => fn (mixed $user) => $user->businessPhones[0] ?? '',
        'mobile' => 'mobilePhone',
        'domains' => fn (mixed $user) => reference('domains')->from($user->domains)->get(),
        'brands' => fn (mixed $user) => reference('brands')->identifiedBy('code')->from($user->brands)->get(),
        'agencies' => fn (mixed $user) => reference('agencies')->from($user->companyName)->get(),
        'status' => fn () => true,
    ],
    'custom_attributes' => [],
];
