<?php

namespace Inside\BELV\Providers;

use Inside\BELV\Listeners\CooptionsCreatedListener;
use Inside\BELV\Listeners\CooptionsUpdatedListener;
use Inside\BELV\Listeners\LeadsCommentCreatedListener;
use Inside\BELV\Listeners\LeadsCreatedListener;
use Inside\BELV\Listeners\LeadsUpdatedListener;
use Inside\BELV\Listeners\VacationsUpdatedListener;
use Inside\Content\Events\CommentCreatedEvent;
use Inside\Content\Events\ContentCreatedEvent;
use Inside\Content\Events\ContentSynchedEvent;
use Inside\Content\Events\ContentUpdatingEvent;
use Inside\Support\EventServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * BELV Service provider.
 *
 * @category Class
 * @package  Inside\BELV\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends EventServiceProvider
{
    protected array $listen = [
        ContentCreatedEvent::class => [
            LeadsCreatedListener::class,
            CooptionsCreatedListener::class,
        ],
        ContentSynchedEvent::class => [
            VacationsUpdatedListener::class,
            LeadsUpdatedListener::class,
            CooptionsUpdatedListener::class,
        ],
        ContentUpdatingEvent::class => [
            LeadsUpdatedListener::class,
        ],
        CommentCreatedEvent::class => [
            LeadsCommentCreatedListener::class,
        ],
    ];

    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/permission.php', 'permission');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__.'/../../config/azuread.php', 'azuread');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
