<?php

use Illuminate\Support\Facades\Artisan;
use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Illuminate\Support\Str;

class AddCodeFieldToBrands extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();
        $bridgeContentType->contentTypeCreateOrUpdateField('brands', 'code', [
            'name' => 'code',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Référence d\'import',
                'nl' => 'Reference'
            ],
            'widget' => [
                'hidden' => true,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ]
        ]);

        $bridgeContentType->contentTypeDeleteField('node', 'domains', 'brands');
        collect(['logo', 'url'])->each(function ($fieldName) use ($bridgeContentType) {
            $bridgeContentType->contentTypeCreateOrUpdateField('brands', $fieldName, [
                'name' => $fieldName,
                'required' => false
            ]);
        });

        Artisan::call('models:rebuild');

        $bridgeContent = new BridgeContent();
        type_to_class('brands')::query()
            ->whereNull('code')
            ->pluck('url', 'uuid')
            ->each(function ($link, $uuid) use ($bridgeContent) {
                $link = Str::after($link, '://');
                $domain = Str::before($link, '/');
                $domain = Str::replaceFirst('www.', '', $domain);

                $bridgeContent->contentUpdate('brands', [
                    'uuid' => $uuid,
                    'code' => $domain
                ]);
            });
    }
}
