<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;
use Inside\Host\Bridge\BridgeContent;
use Inside\Layout\Models\LayoutPath;
use Inside\Layout\Models\Layout;
use Inside\Settings\Models\Setting;

class SeedCustomPages extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        collect([
            ['title' => 'Offres d\'emploi', 'custom_slug' => 'jobs', 'redirection_page' => 'JobsListingPage'],
            ['title' => 'Cap Tempo', 'custom_slug' => 'cap-tempo', 'redirection_page' => 'CapTempoNewsListingPage'],
            ['title' => 'Support', 'custom_slug' => 'support-listing', 'redirection_page' => 'SupportListingPage'],
            ['title' => 'Mes cooptations', 'custom_slug' => 'cooption-listing', 'redirection_page' => 'CooptionListingPage'],
        ])->each(fn ($custom) => $bridge->contentInsert(type: 'custom', data: $custom, fromCli: true));

        collect([
            ['title' => 'Entre vous & nous', 'custom_slug' => 'between-news', 'redirection_page' => 'BetweenNewsListingPage'],
            ['title' => 'Annuaire', 'custom_slug' => 'directory', 'redirection_page' => 'DirectoryPage'],
            ['title' => 'Bibliothèque de ressources', 'custom_slug' => 'ged', 'redirection_page' => 'GedPage'],
            ['title' => 'Tous les deals', 'custom_slug' => 'cross-selling-admin', 'redirection_page' => 'CrossSellingAdminPage'],
            ['title' => 'Ventes croisées', 'old_title' => 'Mes deals', 'custom_slug' => 'cross-selling', 'redirection_page' => 'CrossSellingPage'],
            ['title' => 'Administrer les cooptations', 'old_title' => 'Cooptation Admin', 'custom_slug' => 'cooption-listing-admin', 'redirection_page' => 'CooptionListingPage'],
        ])
            ->map(
                fn ($custom) => Arr::add($custom, 'uuid', DB::table('inside_content_custom')->where('title', $custom['old_title'] ?? $custom['title'])->first()?->uuid)
            )
            ->each(fn ($custom) => $bridge->contentUpdate(type: 'custom', data: Arr::except($custom, 'old_title'), fromCli: true));

        LayoutPath::with('layout')
            ->get()
            ->pluck('layout')
            ->each(fn (Layout $layout) => $layout->delete());
    }
}
