<?php


use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class ChangeNotificationsTypesToSystem extends Migration
{
    public function up(): void
    {
        $notificationTypes = NotificationType::query()
            ->where('via', 'web')
            ->where(function ($query) {
                $query->where('model', 'Inside\Content\Models\Contents\Cooptions')
                    ->orWhere(function ($query) {
                        $query->where('model', 'Inside\Content\Models\Contents\Vacations')
                            ->where('action', 'statusUpdated');
                    })
                    ->orWhere('model', 'Inside\Content\Models\Contents\Leads');
            })
            ->get();

        /** @var NotificationType $notificationType */
        foreach ($notificationTypes as $notificationType) {
            $notificationType->type = "system";
            $notificationType->save();
        }
    }

    public function down(): void
    {
    }
}
