<?php


use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class ChangeVacationsNotificationsToSystem extends Migration
{
    public function up(): void
    {
        $notificationType = NotificationType::query()
            ->where('event', 'Inside\Content\Events\ContentCreatedEvent')
            ->where('model', 'Inside\Content\Models\Contents\Vacations')
            ->where('via', 'web')
            ->where('action', 'create')->first();

        if ($notificationType instanceof NotificationType) {
            $notificationType->type = "system";
            $notificationType->save();
        }
    }

    public function down(): void
    {
    }
}
