<?php

use Illuminate\Database\Migrations\Migration;

class AddVacationsCategories extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('vacations_categories');
        $this->migrateContent('vacations');

        $categories = [
            [
                'title' => 'ASS',
                'default' => true,
            ],
            [
                'title' => 'CSS (congés sans solde)',
                'default' => false,
            ],
            [
                'title' => 'CPA (congés payés annuels)',
                'default' => false,
            ],
        ];

        $console = $this->getConsole();
        $console->writeln('<info>Création des contenus par défaut</info>');

        $bridge = new \Inside\Host\Bridge\BridgeContent();
        foreach ($categories as $category) {
            $bridge->contentInsert(
                'vacations_categories',
                array_merge(
                    $category,
                    [
                        'bundle' => 'vacations_categories',
                        'type' => 'node',
                    ]
                )
            );
        }

        $console->writeln('<comment>'.count($categories).' contenus créés</comment>');
        $this->finishUp();
    }

    public function down(): void
    {
    }
}
