<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddNoteFieldLeads extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridge->contentTypeCreateOrUpdateField(
            'leads',
            'note',
            [
                'name' => 'note',
                'type' => BridgeContentType::TEXTAREA_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Commentaire',
                ],
                'widget' => [
                    'type' => BridgeContentType::LONGTEXT_WIDGET,
                    'settings' => [
                        'rows' => 5,
                        'placeholder' => '',
                    ],
                ],
                'settings' => [
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
