<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Notify\Models\NotificationType;

class AddLeadsMessagesNotificationTypes extends Migration
{
    use CreateContentTypes;

    /**
     * @var BridgeContentType $bridge
     */
    protected $bridge;

    public function up(): void
    {
        $notificationTypes = [];

        // new message on leads
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => false,
                'event' => 'Inside\Content\Events\CommentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Leads',
                'action' => 'leadsCommentCreated',
                'condition' => null,
            ],
            [
                'data' => [
                    'title' => 'notifications.comment.content.leads.title',
                    'description' => 'notifications.comment.content.leads.description',
                    'icon' => 'news',
                    'text' => 'notifications.comment.content.leads.text',
                    'fields' => [
                        'title'
                    ],
                    'url' => 'ROOT_RELATION:leads',
                ],
            ]
        );

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'default' => false,
                'event' => 'Inside\Content\Events\CommentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Leads',
                'action' => 'leadsCommentCreated',
                'condition' => null,
            ],
            [
                'data' => [
                    'title' => 'notifications.comment.content.leads.title',
                    'description' => 'notifications.comment.content.leads.description',
                    'icon' => 'news',
                    'text' => 'notifications.comment.content.leads.text',
                    'fields' => [
                        'title'
                    ],
                    'mail' => [
                        'subject' => 'notifications.comment.content.leads.mail.subject',
                        'text' => 'notifications.comment.content.leads.mail.text',
                        'buttonText' => 'notifications.create.content.leads.mail.buttonText',
                    ],
                    'url' => 'ROOT_RELATION:leads',
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
