<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Brands;
use Inside\Content\Models\Contents\Domains;
use Inside\Host\Bridge\BridgeContent;

class FillDomainsAndBrands extends Migration
{
    public function up(): void
    {
        $domainsBrands = [
            'belvedia.fr' => 'RSI',
            'edelvi.fr' => 'Edelvi',
            'elit-interum.mc' => 'Elit Interim',
            'agencearmada.com' => 'Armada',
            'ehc.fr' => 'EHC',
            'interim-nation.fr' => 'Interim Nation',
            'mastempo.com' => 'Mastempo',
            'pierrepauljac.com' => 'Pierre Paul Jac'
        ];

        $bridge = new BridgeContent();
        foreach ($domainsBrands as $domain => $brand) {
            if (Brands::where('title', $brand)->exists()) {
                $brandUuid = Brands::where('title', $brand)->first()->uuid;
            } else {
                $brandUuid = $bridge->contentInsert(
                    'brands',
                    [
                        'title' => $brand,
                        'type' => 'node',
                        'bundle' => 'brands',
                    ]
                );
            }

            $domainData = [
                'title' => $domain,
                'bundle' => 'domains',
                'type' => 'node',
                'brands' => [$brandUuid],
            ];

            if (Domains::where('title', $domain)->exists()) {
                $domainData['uuid'] = Brands::where('title', $domain)->first()->uuid;
            }

            $bridge->contentInsert('domains', $domainData);
        }
    }

    public function down(): void
    {
    }
}
