<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;

class AddGoogleTestUsers extends Migration
{
    public function up(): void
    {
        $domains = [
            'belvedia.fr',
            'edelvi.fr',
            'elit-interim.mc',
            'agencearmada.com',
            'interim-nation.fr',
            'mastermpo.com',
            'ehc.fr',
            'pierrepauljac.com',
        ];
        $bridge = new BridgeContent();

        foreach ($domains as $domain) {
            try {
                $bridge->contentInsert(
                    'users',
                    [
                        'mail' => "maeciaconnect@$domain",
                        'name' => "maecia_$domain",
                        'status' => true,
                    ]
                );
            } catch (Exception $exception) {
            }
        }
    }

    public function down(): void
    {
    }
}
