<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Notify\Models\NotificationType;

class AddLeadsNotificationTypes extends Migration
{
    use CreateContentTypes;

    /**
     * @var BridgeContentType $bridge
     */
    protected $bridge;

    public function up(): void
    {
        $notificationTypes = [];

        // création lead
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\Content\Events\ContentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Leads',
                'action' => 'create',
                'condition' => '!author:CURRENT_USER',
                'multiple' => false,
                'language' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.create.content.leads.title',
                    'description' => 'notifications.create.content.leads.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.content.leads.text',
                    'fields' => [
                        'title',
                    ],
                ],
            ]
        );

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'default' => true,
                'event' => 'Inside\Content\Events\ContentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Leads',
                'action' => 'create',
                'condition' => '!author:CURRENT_USER',
                'multiple' => false,
                'language' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.create.content.leads.title',
                    'description' => 'notifications.create.content.leads.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.content.leads.text',
                    'mail' => [
                        'subject' => 'notifications.create.content.leads.mail.subject',
                        'text' => 'notifications.create.content.leads.mail.text',
                        'buttonText' => 'notifications.create.content.leads.mail.buttonText',
                    ],
                    'fields' => [
                        'title',
                    ],
                ],
            ]
        );

        // Change delivery (to author)
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\Content\Events\ContentSynchedEvent',
                'model' => 'Inside\Content\Models\Contents\Leads',
                'action' => 'deliveryUpdated',
                'condition' => '!author:CURRENT_USER',
                'multiple' => false,
                'language' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.create.content.leads.delivery.updated.title',
                    'description' => 'notifications.create.content.leads.delivery.updated.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.content.leads.delivery.updated.text',
                    'fields' => [
                        'title',
                    ],
                ],
            ]
        );

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'default' => true,
                'event' => 'Inside\Content\Events\ContentSynchedEvent',
                'model' => 'Inside\Content\Models\Contents\Leads',
                'action' => 'deliveryUpdated',
                'condition' => '!author:CURRENT_USER',
                'multiple' => false,
                'language' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.create.content.leads.delivery.updated.title',
                    'description' => 'notifications.create.content.leads.delivery.updated.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.content.leads.delivery.updated.text',
                    'mail' => [
                        'subject' => 'notifications.create.content.leads.delivery.updated.mail.subject',
                        'text' => 'notifications.create.content.leads.delivery.updated.mail.text',
                        'buttonText' => 'notifications.create.content.leads.mail.buttonText',
                    ],
                    'fields' => [
                        'title',
                    ],
                ],
            ]
        );

        // Change delivery (to delivery)
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\Content\Events\ContentSynchedEvent',
                'model' => 'Inside\Content\Models\Contents\Leads',
                'action' => 'deliveryAssigned',
                'condition' => '!author:CURRENT_USER',
                'multiple' => false,
                'language' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.create.content.leads.delivery.assigned.title',
                    'description' => 'notifications.create.content.leads.delivery.assigned.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.content.leads.delivery.assigned.text',
                    'fields' => [
                        'title',
                    ],
                ],
            ]
        );

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'default' => true,
                'event' => 'Inside\Content\Events\ContentSynchedEvent',
                'model' => 'Inside\Content\Models\Contents\Leads',
                'action' => 'deliveryAssigned',
                'condition' => '!author:CURRENT_USER',
                'multiple' => false,
                'language' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.create.content.leads.delivery.assigned.title',
                    'description' => 'notifications.create.content.leads.delivery.assigned.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.content.leads.delivery.assigned.text',
                    'mail' => [
                        'subject' => 'notifications.create.content.leads.delivery.assigned.mail.subject',
                        'text' => 'notifications.create.content.leads.delivery.assigned.mail.text',
                        'buttonText' => 'notifications.create.content.leads.mail.buttonText',
                    ],
                    'fields' => [
                        'title',
                    ],
                ],
            ]
        );

        // Updated
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => '',
                'model' => 'Inside\Content\Models\Contents\Leads',
                'action' => 'update',
                'condition' => '!author:CURRENT_USER',
                'multiple' => false,
                'language' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.create.content.leads.updated.title',
                    'description' => 'notifications.create.content.leads.updated.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.content.leads.updated.text',
                    'fields' => [
                        'title',
                    ],
                ],
            ]
        );

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'default' => true,
                'event' => '',
                'model' => 'Inside\Content\Models\Contents\Leads',
                'action' => 'update',
                'condition' => '!author:CURRENT_USER',
                'multiple' => false,
                'language' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.create.content.leads.updated.title',
                    'description' => 'notifications.create.content.leads.updated.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.content.leads.updated.text',
                    'mail' => [
                        'subject' => 'notifications.create.content.leads.updated.mail.subject',
                        'text' => 'notifications.create.content.leads.updated.mail.text',
                        'buttonText' => 'notifications.create.content.leads.mail.buttonText',
                    ],
                    'fields' => [
                        'title',
                    ],
                ],
            ]
        );

        // Amount Invoiced Updated
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => '',
                'model' => 'Inside\Content\Models\Contents\Leads',
                'action' => 'amountInvoicedUpdated',
                'condition' => '!author:CURRENT_USER',
                'multiple' => false,
                'language' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.create.content.leads.updated.amount_invoiced.title',
                    'description' => 'notifications.create.content.leads.updated.amount_invoiced.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.content.leads.updated.amount_invoiced.text',
                    'fields' => [
                        'title',
                    ],
                ],
            ]
        );

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'default' => true,
                'event' => '',
                'model' => 'Inside\Content\Models\Contents\Leads',
                'action' => 'amountInvoicedUpdated',
                'condition' => '!author:CURRENT_USER',
                'multiple' => false,
                'language' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.create.content.leads.updated.amount_invoiced.title',
                    'description' => 'notifications.create.content.leads.updated.amount_invoiced.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.content.leads.updated.amount_invoiced.text',
                    'mail' => [
                        'subject' => 'notifications.create.content.leads.updated.amount_invoiced.mail.subject',
                        'text' => 'notifications.create.content.leads.updated.amount_invoiced.mail.text',
                        'buttonText' => 'notifications.create.content.leads.mail.buttonText',
                    ],
                    'fields' => [
                        'title',
                    ],
                ],
            ]
        );

        // Status Updated
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => '',
                'model' => 'Inside\Content\Models\Contents\Leads',
                'action' => 'statusUpdated',
                'condition' => '!author:CURRENT_USER',
                'multiple' => false,
                'language' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.create.content.leads.updated.status.title',
                    'description' => 'notifications.create.content.leads.updated.status.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.content.leads.updated.status.text',
                    'fields' => [
                        'title',
                    ],
                ],
            ]
        );

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'default' => true,
                'event' => '',
                'model' => 'Inside\Content\Models\Contents\Leads',
                'action' => 'statusUpdated',
                'condition' => '!author:CURRENT_USER',
                'multiple' => false,
                'language' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.create.content.leads.updated.status.title',
                    'description' => 'notifications.create.content.leads.updated.status.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.content.leads.updated.status.text',
                    'mail' => [
                        'subject' => 'notifications.create.content.leads.updated.status.mail.subject',
                        'text' => 'notifications.create.content.leads.updated.status.mail.text',
                        'buttonText' => 'notifications.create.content.leads.mail.buttonText',
                    ],
                    'fields' => [
                        'title',
                    ],
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
