<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class DeleteJobsBrands extends Migration
{
    use CreateContentTypes;

    /**
     * @var BridgeContentType $bridge
     */
    protected $bridge;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        try { // exception thrown if jobs_brand does not exist (if already deleted)
            $this->bridge->contentTypeDelete('jobs_brands');
        } catch (Exception $e) {
        }

        $contentTypesWithReference = [
            'between_news',
            'jobs',
        ];

        foreach ($contentTypesWithReference as $contentType) {
            $this->bridge->contentTypeDeleteField('node', $contentType, 'jobs_brands');
        }

        $this->finishUp();
    }

    public function down(): void
    {
    }
}
