<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable' => false,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => true,
        'permissible' => false,
        'categorizable' => false,
        'name' => 'vacations',
        'title' => [
            'fr' => 'Demandes de congés',
        ],
    ],
    'fields' => [
        [
            'name' => 'date_start',
            'type' => BridgeContentType::TIMESTAMP_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Date de début'
            ],
            'widget' => [
                'type' => BridgeContentType::TIMESTAMP_WIDGET,
                'settings' => [],
                'weight' => $weight++
            ],
            'settings' => [
                'cardinality' => 1
            ],
        ],
        [
            'name' => 'date_start_duration',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Dureée',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'settings' => [
                'target_type' => ['vacations_durations'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'date_end',
            'type' => BridgeContentType::TIMESTAMP_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Date de début'
            ],
            'widget' => [
                'type' => BridgeContentType::TIMESTAMP_WIDGET,
                'settings' => [],
                'weight' => $weight++
            ],
            'settings' => [
                'cardinality' => 1
            ],
        ],
        [
            'name' => 'date_end_duration',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Dureée',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'settings' => [
                'target_type' => ['vacations_durations'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'comment',
            'type' => BridgeContentType::LONGTEXT_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Commentaire',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'validator',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Valideur',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'settings' => [
                'target_type' => 'users',
                'cardinality' => -1,
            ],
        ],
    ],
];
