import { http } from '@inside-library/helpers/Http'

const getRedirectionUrl = async data => {
  try {
    const parent = await http.get(
      `content/tree/${
        data.data.content_type ||
        data.data.type ||
        data.contentType ||
        data.content_type
      }/${data.data.uuid || data.uuid}`
    )

    return {
      name: 'ModalDocument',
      params: {
        folder: parent.root.slug,
        ...(parent.parent && { subFolder: parent.parent.slug }),
        document: parent.content.slug
      }
    }
  } catch (err) {
    return { path: '/' }
  }
}

const deleteRedirection = async ({ uuid }) => {
  try {
    const parent = await http.get(`content/tree/sops/${uuid}`)

    return {
      name: 'GedPageCustom',
      params: {
        folder: parent.root.slug,
        ...(parent.parent && { subFolder: parent.parent.slug })
      }
    }
  } catch (err) {
    return { path: '/' }
  }
}

const fallbackRedirection = async data => {
  return `/external-url/${data.data.content_type || data.data.type}/${
    data.data.uuid
  }`
}

export default {
  proceduresCategories: {
    add: ({ data }) => ({ name: 'LHGPage', query: { tab: data.uuid } }),
    delete: () => ({ name: 'LHGPage' })
  },
  procedures: {
    add: async ({ data }) => {
      try {
        const { data: procedure } = await http.get('content/procedures', {
          fields: ['uuid', 'slug'],
          filters: { 'uuid:eq': data.uuid }
        })

        return {
          name: 'ProcedureModal',
          ...(procedure[0].slug && {
            params: {
              slug: procedure[0].slug[0]
            }
          })
        }
      } catch (err) {
        return { path: '/' }
      }
    },
    delete: () => ({ name: 'LHGPage' })
  },
  brandForms: {
    add: ({ data }) => ({
      name: 'BrandFormPage',
      params: { slug: data.slug[0] }
    })
  },
  businessUnits: {
    add: () => ({
      name: 'HomePage'
    }),
    delete: () => ({
      name: 'HomePage'
    })
  },
  sops: {
    add: getRedirectionUrl,
    delete: deleteRedirection,
    fallback: fallbackRedirection
  },
  rops: {
    add: getRedirectionUrl,
    delete: deleteRedirection,
    fallback: fallbackRedirection
  },
  documents: {
    add: getRedirectionUrl,
    delete: deleteRedirection,
    fallback: fallbackRedirection
  },
  declinedDocuments: {
    add: getRedirectionUrl,
    delete: deleteRedirection,
    fallback: fallbackRedirection
  },
  photo: {
    add: getRedirectionUrl,
    delete: deleteRedirection,
    fallback: fallbackRedirection
  },
  folders: {
    add: async ({ data }) => {
      try {
        const parent = await http.get(`content/tree/folders/${data.uuid}`)

        return {
          name: 'GedPageCustom',
          params: {
            folder: parent.root?.slug || parent.content.slug,
            ...(parent.root && { subFolder: parent.content.slug })
          }
        }
      } catch (err) {
        return { path: '/' }
      }
    },
    delete: async ({ uuid }) => {
      try {
        const parent = await http.get(`content/tree/folders/${uuid}`)

        return {
          name: 'GedPageCustom',
          params: {
            folder: parent.root?.slug,
            ...(parent.parent && { subFolder: parent.parent.slug })
          }
        }
      } catch (err) {
        return { path: '/' }
      }
    }
  }
}
