/**
 * @BrandManager
 */

import { storage } from '@inside-library/helpers/Storage'

const BrandManager = {}

export default BrandManager.install = app => {
  const getStyleTag = () => {
    const styleTag = document.createElement('style')

    styleTag.type = 'text/css'
    styleTag.setAttribute('id', 'custom-brand-style')

    return styleTag
  }

  const getStyleProperties = () => {
    const styleTypes = {
      color: {
        main: [
          '.header-users__content i',
          '.header-users__menu a:hover',
          '.tabs__nav li:hover, .tabs__nav li.active',
          '.header__user-action > a:hover, .header__user-action > div:hover',
          '.custom-main-search__infos-filters .filter-active',
          '.custom-main-search__infos-filters li:hover',
          '.custom-field-search--main .custom-field-search__input i',
          '.custom-main-search__cross',
          '.paragraph-accordion__title i',
          '.paragraph-accordion__title:hover p',
          '.input__attachment + label.btn',
          '.footer-common--left > a:hover',
          '.sidebar-ged__title p, .sidebar-ged__title i',
          '.folder-ged i.sid2-folder-filled',
          '.minimal-ged__single i',
          '.list-ged--declensions li i',
          '.doc-ged-modal .paragraph-file__container i',
          '.doc-ged-modal .paragraph-file__title',
          '.modal__actions i',
          '.modal__body__actions a i',
          '.modal__body__actions a i:hover',
          '.resume i',
          '.resume:hover .resume__title',
          '.doc-ged-modal .modal__body-footer a, div .doc-ged-modal .modal__body-footer__obsolete',
          '.doc-ged-modal .modal__body--infos .email',
          '.custom-field-search__dropdown li:last-of-type',
          '.header-notifications a:hover i, .header-notifications__active i',
          '.notification-item__spaced i',
          '.breadcrumb-ged__label:not(.breadcrumb-ged__label--last):hover',
          '.report-content-ui--compact .report-content__btn',
          '.folder-ged--active i',
          '.gallery__infos div',
          '.gallery__infos a',
          '.formatted-references--clickable:hover',
          '.workflow-group__submit--accept:hover',
          '.form-main .input__attachment-container .btn:hover',
          '.form-main .input__attachment-container .btn:hover',
          '.submit-reply-form .btn:hover',
          '.reply-aside-block .btn:hover',
          '.menu-common__lvl1__link:hover, .menu-common__lvl1__link.router-link-active',
          '.folder-tab-item .subfolder-link::before',
          '.my-brand-container .slider-container .swiper-button-prev::before, .my-brand-container .slider-container .swiper-button-next::before',
          '.my-brand-container .slider-container .swiper-button-prev::before, .my-brand-container .slider-container .swiper-button-prev::before',
          '.ebook-btn.appearance-primary:hover'
        ],
        second: ['.list-ged i']
      },
      background: {
        main: [
          '.folder-ged--active > .folder-ged__title',
          '.folder-ged__icon--closed',
          '.folder-ged__icon--opened::before, .folder-ged__icon--opened::after',
          '.modal__header .modal-container__close:hover::before, .modal__header .modal-container__close:hover::after',
          '.paragraph-steps',
          '.header__burger__element span',
          'div.doc-ged-modal .modal__header .tabs-container .tabs__nav li.active::after',
          '.sidebar-ged .folder-ged:not(.folder-ged--active) .sid2-arrow::after',
          '.v--modal > div::-webkit-scrollbar-thumb',
          '.tabs-paragraph__header li::after',
          '.card-ged__player',
          '.workflow-group__submit--accept',
          '.form-main .input__attachment-container .btn',
          '.activity-users-customs__slideshow .swiper-button-prev::before',
          '.activity-users-customs__slideshow .swiper-button-next::before',
          '.ds-button-container.primary:not(.admin)::before'
        ],
        second: [
          '.sub-header-ui',
          '.full-ged__header--bg',
          '.doc-ged-modal .modal__header',
          '.brand-forms::before',
          '.form-layout-container .page-header'
        ]
      },
      backgroundColor: {
        main: [
          '.menu-common__lvl1__link::after',
          '.menu-common__lvl2',
          '.add-btn-ui',
          '.header-users__infos',
          '.flickity-page-dots li.dot.is-selected',
          '.paragraph-slider .flickity-page-dots .dot:hover',
          '.modal__header .modal-container__close::before, .modal__header .modal-container__close::after',
          '.list-ged--master::after',
          '.header-notifications__dropdown-body > div:not(.loader-ui)::-webkit-scrollbar-thumb',
          '.submit-reply-form .btn',
          '.reply-aside-block .btn',
          '.modal__body--infos .infos__content::after',
          '.ebook-btn::before',
          '.my-brand-container .slider-container .swiper-button-prev::before, .my-brand-container .slider-container .swiper-button-next::before',
          '.my-brand-container .slider-container .swiper-button-prev::before, .my-brand-container .slider-container .swiper-button-prev::before',
          '.my-brand-container .swiper-container .swiper-pagination .swiper-pagination-bullet-active'
        ],
        second: [
          '.form__img',
          '.bookmark-page .banner-container',
          '.cart-page .banner-container'
        ]
      },
      borderColor: {
        main: [
          '.add-btn-ui',
          '.custom-field-search--main .custom-field-search__input input',
          '.paragraph-file__container',
          '.paragraph-files',
          '.flickity--blue-button .flickity-button',
          '.paragraph-steps',
          '.dashboard:hover',
          '.sidebar-ged',
          '.custom-field-search__dropdown li:hover',
          '.workflow-group__submit--accept',
          '.activity-users-customs__slideshow .swiper-button-prev::before',
          '.activity-users-customs__slideshow .swiper-button-next::before',
          '.form-main .input__attachment-container .btn',
          '.submit-reply-form .btn',
          '.reply-aside-block .btn',
          'div.reply-aside-block',
          '.ebook-btn'
        ],
        second: [
          '.activity-users-customs__slideshow .swiper-button-prev::after',
          '.activity-users-customs__slideshow .swiper-button-next::after'
        ]
      },
      borderLeftColor: {
        main: [
          '.paragraph-steps .step__img::after',
          '.default-text ul:not([style*="circle"]):not([style*="disc"]):not([style*="square"]) li::before',
          '.modal__body--infos .infos__content + .infos__content'
        ]
      },
      borderRightColor: {
        main: []
      },
      stroke: {
        main: ['.loader-ui__path'],
        second: []
      },
      fill: {
        main: [
          '.header__user-action a:hover svg',
          '.print path',
          '.bookmark-ui svg',
          'div.maps__marker--no-color .vector-marker path',
          '.report-content-ui svg',
          '.list-ged--declension .icon-ui-arrow-link',
          '.report-container .ds-icon-container',
          '.notifications-header-container > div .ds-icon-container:hover',
          '.paragraph-file__container--left .ds-icon-container',
          '.folder-item-container .svg-folder-container',
          '.doc-ged-modal .modal__header .close-icon',
          '.ebook-btn:hover svg'
        ],
        second: [
          '.flickity-prev-next-button > .flickity-button-icon',
          'div.flickity--blue-button .flickity-button:hover .flickity-button-icon'
        ]
      }
    }

    const brand = storage.get('brand')

    const colors = {
      main: brand?.primary_color,
      second: brand?.secondary_color
    }

    return generateStyleProperties(styleTypes, colors)
  }

  const generateStyleProperties = (styleTypes, colors) => {
    let styleProperties = []

    for (const styleType in styleTypes) {
      const colorTypes = styleTypes[styleType]

      for (const colorType in colorTypes) {
        const classes = colorTypes[colorType]

        if (classes.length > 0) {
          const color = colors[colorType]
          const formattedClassses = classes.join(',\n')
          const formattedStyleType = styleType
            .replace(/([a-z])([A-Z])/g, '$1-$2')
            .toLowerCase()
          const formattedProperties = `${formattedClassses} {${formattedStyleType}: ${color} !important}`

          styleProperties.push(formattedProperties)
        }
      }
    }

    const globalStyleProperties = [
      `input[type="text"] {caret-color: ${colors.main} !important}`
    ]

    styleProperties.push(globalStyleProperties)

    return styleProperties.join('\n')
  }

  app.config.globalProperties.updateBrandStyle = () => {
    let customStyleElement = document.getElementById('custom-brand-style')

    if (!document.getElementById('custom-brand-style')) {
      customStyleElement = getStyleTag()
      document.getElementsByTagName('head')[0].appendChild(customStyleElement)
    }

    customStyleElement.textContent = getStyleProperties()
  }
}
