import { formatHref } from '@inside-library/helpers/Langs'

export default {
  methods: {
    async makeRedirection(item) {
      if (!item) return '/'

      this.$store.commit('setCurrentModalContentType', item.content_type)

      const method = this.$_getRedirectionMethod(item.content_type)
      const redirection = await method({ data: item })

      if (redirection) {
        this.$router.push(formatHref(redirection, this.$_currentLang))
      }
    }
  }
}
