import { storage } from '@inside-library/helpers/Storage'
import { http } from '@inside-library/helpers/Http'

export default {
  data() {
    return {
      brandsFields: [
        'uuid',
        'title',
        'banner_image',
        'brand_logo',
        'header_logo',
        'menu_icon',
        'brand_block_text',
        'sop_block_text',
        'brand_block_button_text',
        'sop_block_button_text',
        'brand_block_title',
        'sop_block_title',
        'sop_block_text_color',
        'brand_block_text_color',
        'secondary_color',
        'primary_color',
        'brand_block_button_color',
        'button_color',
        'brand_block_bg_color',
        'sop_block_bg_color',
        'sop_block_button_color',
        'button_bg',
        'sop_block_button_bg',
        'brand_block_button_bg',
        'sop_block_bg_image',
        'brand_block_bg_image',
        'weight',
        'legal_mentions',
        'brand_block_link',
        'sop_block_link',
        'code',
        'users',
        'content',
        'langcode'
      ],
      brandsMenuFields: [
        'uuid',
        'title',
        'banner_image',
        'brand_logo',
        'header_logo',
        'menu_icon',
        'code',
        'weight',
        'legal_mentions',
        'secondary_color',
        'primary_color',
        'users'
      ]
    }
  },
  methods: {
    async getBrands() {
      try {
        const { data: brands } = await http.get('content/users', {
          fields: [
            'uuid',
            {
              brands: {
                fields: this.brandsMenuFields,
                filters: { sort: 'weight:asc', 'status:eq': 1 }
              }
            }
          ],
          filters: {
            'uuid:eq': this.getUserInfos.uuid,
            langcode: this.$_currentLang
          }
        })

        return brands[0].brands.data
      } catch (err) {
        throw new Error(err)
      }
    },
    async getCurrentBrand() {
      try {
        const { data: currentBrand } = await http.get('content/brands', {
          fields: this.brandsFields,
          filters: {
            'title:eq': storage.get('brand')?.title,
            langcode: this.$_currentLang
          }
        })

        return currentBrand[0]
      } catch (err) {
        throw new Error(err)
      }
    }
  }
}
