import insideConfig from './inside.config.js'
import routes from './router'
import redirections from './redirections'

import BrandManager from './plugins/BrandManager'

import DocGedTabsModal from '../inside-overrides/inside-ged/modals/DocGedTabsModal'
import FooterLayouts from '../inside-overrides/inside-layouts/FooterLayouts'
import HeaderLayouts from '../inside-overrides/inside-layouts/HeaderLayouts'
import MobileHeaderLayouts from '../inside-overrides/inside-layouts/MobileHeaderLayouts'
import ParagraphListing from '../inside-overrides/inside-library/listing/ParagraphListing'
import FileParagraph from '../inside-overrides/inside-library/paragraphs/FileParagraph'
import FilesParagraph from '../inside-overrides/inside-library/paragraphs/FilesParagraph'
import StepsParagraph from '../inside-overrides/inside-library/paragraphs/StepsParagraph'
import TabsParagraph from '../inside-overrides/inside-library/paragraphs/TabsParagraph'

export default {
  name: 'inside-customs',
  init: app => {
    app.component('doc-ged-tabs-modal', DocGedTabsModal)
    app.component('footer-layouts', FooterLayouts)
    app.component('header-layouts', HeaderLayouts)
    app.component('mobile-header-layouts', MobileHeaderLayouts)
    app.component('paragraph-listing', ParagraphListing)
    app.component('file-paragraph', FileParagraph)
    app.component('files-paragraph', FilesParagraph)
    app.component('steps-paragraph', StepsParagraph)
    app.component('tabs-paragraph', TabsParagraph)
  },
  redirections,
  routes,
  plugin: BrandManager,
  insideConfig
}
