const CONTENTS = (
  { folderContents, documentsContents } = {
    folderContents: ['folders'],
    documentsContents: ['documents']
  }
) => ({
  folders: {
    contents: folderContents,
    filters: {
      'status:eq': 1,
      sort: 'title:asc'
    },
    fields: [
      'uuid',
      'content_type',
      'created_at',
      'published_at',
      'langcode',
      'status',
      'title',
      'media_folder_intro',
      'admin',
      'image',
      'is_media_folder',
      'pid',
      'slug',
      {
        parent_tree: {
          fields: [
            'uuid',
            'title',
            'content_type',
            'published_at',
            'updated_at',
            'color',
            'slug'
          ],
          filters: {
            content_type: folderContents,
            sort: 'created_at:asc'
          }
        }
      },
      'color',
      { reactions: ['count', { users: ['uuid'] }] }
    ]
  },
  documents: {
    contents: documentsContents,
    filters: {
      'status:eq': 1,
      sort: 'created_at:asc'
    },
    fields: [
      'uuid',
      'content_type',
      'created_at',
      'published_at',
      'langcode',
      'status',
      'title',
      'admin',
      'has_section',
      'body',
      'file',
      'introduction',
      'image',
      'slug',
      { reactions: ['count', { users: ['uuid'] }] }
    ]
  }
})

export { CONTENTS }
