import GedFieldsMixin from './ged-fields-mixin'

import { CONTENTS } from '../../../constants/ged-contents'

import { storage } from '@inside-library/helpers/Storage'

export default {
  mixins: [GedFieldsMixin],
  data() {
    return {
      folderContent: CONTENTS().folders,
      documentContent: CONTENTS().documents
    }
  },
  methods: {
    requestFolder(params) {
      this.isLoading = true
      this.setStoreAction('setLoadingGEDStatus', true)

      const fields = this.getFullFields()
      const contentType = this.folderContent.contents[0]

      this.get(`content/${contentType}`, {
        params: {
          currentBrand: storage.get('brand').uuid,
          filters: JSON.stringify({
            ...{ slug: params.data.slug },
            ...{ langcode: this.$_currentLang, status: 1 }
          }),
          fields: JSON.stringify(fields)
        }
      }).then(
        result => {
          params.data.documents = result.data.data
          this.requestCallback(result, params)
        },
        err => {
          this.$_triggerErrorToast({
            text: err
          })
        }
      )
    },
    requestCallback(result, params) {
      if (result.status === 200) {
        history.pushState(
          null,
          null,
          `/${this.$_currentLang}/${this.$route.params.folder}/${(!this
            .getGEDHome &&
            params.slug) ||
          params.data.slug}`
        )

        this.setStoreAction('setCurrentFolder', result.data.data[0])

        if (this.$store.getters.getGEDSearchStatus) {
          this.setStoreAction('setGEDSearchStatus', false)
        }

        this.setStoreAction('setLoadingGEDStatus', false)

        this.setStoreAction('setCurrentHashGed', this.$route.params.subFolder)
      }
    }
  },
  computed: {
    getSearchQuery() {
      if (!this.$store.getters.getSearchList) {
        return
      }

      return this.$store.getters.getSearchList?.ged
    },
    getFullGedCustom() {
      return this.$store.getters.getFullGedCustom
    },
    getCurrentContentType() {
      return type => {
        if (type === 'folders') {
          return this.folderContent.contents[0]
        }

        return this.documentContent.contents[0]
      }
    },
    getGEDHome() {
      return this.$store.getters.getGEDHome
    }
  }
}
