import ReplaceVariableLangcode from '../../../mixins/replace-variable-langcode'
import { storage } from '@inside-library/helpers/Storage'

export default {
  mixins: [ReplaceVariableLangcode],
  created() {
    this.defineDatas()
  },
  methods: {
    defineDatas() {
      this.gedFields = this.m_replaceVariablesLangcode([
        'admin',
        {
          authors: ['lastname', 'firstname']
        },
        'body',
        'content_type',
        'slug',
        'published_at',
        'file',
        'introduction',
        'is_media_folder',
        'langcode',
        'pid',
        'status',
        'title',
        'updated_at',
        'uuid',
        'uuid_host',
        'goal',
        'process',
        'standard',
        'image',
        {
          countries: {
            filters: { langcode: '{currentLang}' },
            fields: ['title', 'total']
          }
        },
        {
          users: ['firstname', 'lastname', 'email']
        },
        {
          reactions: {
            fields: [
              'count',
              {
                users: ['uuid']
              }
            ]
          }
        },
        {
          brands: {
            fields: ['uuid']
          }
        }
      ])

      this.folderFields = [
        'uuid',
        'title',
        'content_type',
        'is_media_folder',
        'slug',
        'admin'
      ]

      this.generalFilters = {
        limit: null,
        offset: null,
        reverse: true,
        sort: 'title:asc',
        'status:eq': 1
      }

      this.declinedProperties = {
        filters: this.generalFilters,
        fields: [
          'admin',
          'content_type',
          'slug',
          'published_at',
          'updated_at',
          'uuid',
          'goal',
          'infos',
          'standard',
          'langcode',
          'status',
          'title',
          {
            countries: {
              filters: { langcode: this.$_currentLang },
              fields: ['title', 'total']
            }
          },
          {
            brands: {
              fields: ['uuid']
            }
          },
          {
            folders: {
              fields: ['uuid']
            }
          },
          {
            sops: {
              fields: ['uuid']
            }
          }
        ]
      }
    },
    getSidebarFields() {
      return [
        {
          [this.getCurrentContentType('folders')]: {
            filters: this.generalFilters,
            fields: [
              ...this.folderFields,
              {
                [this.getCurrentContentType('folders')]: {
                  filters: this.generalFilters,
                  fields: this.folderFields
                }
              }
            ]
          }
        }
      ]
    },
    getFullFields() {
      return [
        ...this.gedFields,
        {
          parent_tree: {
            fields: ['uuid', 'title', 'slug'],
            filters: {
              content_type: this.getCurrentContentType('folders'),
              reverse: true,
              sort: 'title:asc'
            }
          }
        },
        {
          [`${this.getCurrentContentType(
            'folders'
          )}.${this.getCurrentContentType('folders')}`]: {
            currentBrand: storage.get('brand').uuid,
            filters: {
              ...this.generalFilters,
              alias: this.getCurrentContentType('folders')
            },
            fields: this.gedFields
          }
        },
        {
          sops: {
            filters: this.generalFilters,
            fields: [...this.gedFields, { rops: this.declinedProperties }]
          }
        },
        { rops: this.declinedProperties },
        {
          photo: {
            filters: this.generalFilters,
            fields: [
              'admin',
              'content_type',
              'published_at',
              'uuid',
              'langcode',
              'status',
              'title',
              'file',
              'image',
              'preview',
              {
                reactions: {
                  fields: [
                    'count',
                    {
                      users: ['uuid']
                    }
                  ]
                }
              }
            ]
          }
        },
        {
          [this.getCurrentContentType()]: {
            filters: this.generalFilters,
            fields: [
              ...this.gedFields,
              { declined_documents: this.declinedProperties }
            ]
          }
        }
      ]
    }
  }
}
