export default {
  computed: {
    requestFilters() {
      return {
        archived: 0,
        folders: {
          root: this.fetchedData.uuid
        },
        sops: {
          'uuid:eq': null
        },
        sort: 'published_at:desc'
      }
    },
    fields() {
      const defaultFields = [
        'uuid',
        'title',
        'admin',
        'content_type',
        'status',
        'published_at',
        'slug',
        { brands: { fields: ['title', 'uuid'] } },
        { countries: { fields: ['title', 'uuid'] } },
        { workflow: { fields: ['status'] } }
      ]

      return [
        ...defaultFields,
        {
          rops: {
            filters: { reverse: true, archived: 0 },
            fields: ['pid', ...defaultFields]
          }
        },
        {
          declined_documents: {
            filters: { reverse: true, archived: 0 },
            fields: ['pid', ...defaultFields]
          }
        }
      ]
    }
  }
}
