import ContentStatusMixin from '@inside-administration/mixins/content-status'

import headers from './headers.js'
import actions from './actions.js'

const CONTENTS = ['documents', 'rops', 'sops']

export default {
  mixins: [headers, actions, ContentStatusMixin],
  data() {
    return {
      filterId: 'dashboard-filters',
      listingId: 'dashboard-listing',
      searchContents: CONTENTS,
      selectedContentType: null
    }
  },
  computed: {
    selectedItems() {
      return this.$store.getters.getListingDataById({
        id: this.listingId,
        key: 'selectedItems',
        defaultValue: []
      })
    },
    contentTypeSelected() {
      return this.searchContents && this.searchContents.length === 1
    }
  },
  methods: {
    handleContentTypeChange({ value }) {
      this.searchContents = value ? [value] : CONTENTS
      this.selectedContentType = value

      this.$store.commit('setListingData', {
        id: this.listingId,
        key: 'selectedItems',
        data: []
      })
    }
  }
}
