export default {
  computed: {
    filters() {
      return [
        {
          modelName: 'search',
          type: 'text',
          placeholder: this.$_tr('filters.search')
        },
        {
          modelName: 'brands',
          type: 'selectbox',
          fetch: true,
          fields: ['uuid', 'title'],
          filters: { 'status:eq': 1, sort: 'title:asc' },
          reference: 'brands',
          label: this.$_tr('filters.brands'),
          objectLabelKey: 'title',
          objectValueKey: 'uuid'
        },
        {
          modelName: 'countries',
          type: 'selectbox',
          fetch: true,
          fields: ['uuid', 'title'],
          filters: { 'status:eq': 1, sort: 'title:asc' },
          reference: 'countries',
          label: this.$_tr('filters.countries'),
          objectLabelKey: 'title',
          objectValueKey: 'uuid'
        },
        {
          modelName: 'contentType',
          type: 'selectbox',
          label: this.$_tr('filters.contentType'),
          filterOn: 'content_type',
          equality: null,
          inputData: [
            {
              title: this.$_tr('contentTypes.documents'),
              value: 'documents'
            },
            {
              title: this.$_tr('contentTypes.rops'),
              value: 'rops'
            },
            {
              title: this.$_tr('contentTypes.sops'),
              value: 'sops'
            }
          ],
          objectLabelKey: 'title',
          objectValueKey: 'value',
          listeners: {
            onInputMount: this.handleContentTypeChange,
            onDataChange: this.handleContentTypeChange
          }
        }
      ]
    }
  }
}
