import Downloader from 'js-file-downloader'

export default {
  data() {
    return {
      scale: 3.5
    }
  },
  methods: {
    generateCard() {
      this.generateState = this.$options.$_generateSteps[1]

      const firstPage = document.querySelector(
        '.brand-forms__tpl__content .cut-line:first-child'
      )
      const secondPage = document.querySelector(
        '.brand-forms__tpl__content .cut-line:last-child'
      )

      this.post('bclh/image/export', {
        width: `${this.getCurrentCardSize.width * this.scale}px`,
        height: `${this.getCurrentCardSize.height * this.scale}px`,
        page1: firstPage.outerHTML,
        page2: secondPage.outerHTML,
        type: 'pdf'
      }).then(res => {
        new Downloader({
          url: res.data.path,
          filename: `${this.filename}.${this.extension}`
        }).then(() => {
          this.generateState = this.$options.$_generateSteps[2]
          this.resetForm()

          setTimeout(() => {
            this.generateState = this.$options.$_generateSteps[0]
          }, 2000)
        })
      })
    }
  },
  computed: {
    getCurrentCardSize() {
      return this.$store.getters.getCurrentCardSize
    }
  }
}
