const state = {
  cartCounter: 0,
  currentTemplateData: {},
  currentTemplateError: {},
  currentCardSize: {},
  deletionCartStatus: false,
  currentModalContentType: 'documents,declined_documents,sops,rops,procedures',
  /** GED */
  showGEDHome: true,
  rootData: [],
  currentFolder: null,
  currentUrlParts: [],
  loadingStatus: false,
  previewInfos: false,
  gedSearchStatus: false,
  fullGedCustom: {},
  fullGEDContentsOptions: {}
}

/**
 * Getters
 */
const getters = {
  getCartCounter(state) {
    return state.cartCounter
  },
  getCurrentTemplateData: state => state.currentTemplateData,
  getCurrentTemplateError: state => state.currentTemplateError,
  getCurrentCardSize: state => state.currentCardSize,
  getDeletionCartStatus: state => state.deletionCartStatus,
  getCurrentModalContentType: state => state.currentModalContentType,
  /** GED */
  getRootData: state => state.rootData,
  getCurrentFolder: state => state.currentFolder,
  getGEDHome: state => state.showGEDHome,
  getCurrentUrlParts: state => state.currentUrlParts,
  getLoadingGEDStatus: state => state.loadingStatus,
  getPreviewGEDInfos: state => state.previewInfos,
  getGEDSearchStatus: state => state.gedSearchStatus,
  getFullGedCustom: state => state.fullGedCustom,
  getFullGEDContentsOptions: state => state.fullGEDContentsOptions
}

/**
 * Mutations
 */
const mutations = {
  updateCartCounter(state, payload = { remove: false, sum: 1 }) {
    const { remove, sum } = payload

    if (payload.init) {
      state.cartCounter = sum
    } else {
      state.cartCounter = remove
        ? state.cartCounter - sum
        : state.cartCounter + sum
    }
  },
  setCurrentTemplateData(state, payload) {
    state.currentTemplateData = payload
  },
  setCurrentTemplateError(state, payload) {
    state.currentTemplateError = payload
  },
  setCurrentCardSize(state, payload) {
    state.currentCardSize = payload
  },
  setDeletionCartStatus(state, payload) {
    state.deletionCartStatus = payload
  },
  setCurrentModalContentType(state, payload) {
    state.currentModalContentType = payload
  },
  /** GED */
  setRootData(state, payload) {
    state.rootData = payload
  },
  setCurrentFolder(state, payload) {
    state.currentFolder = payload
  },
  setGEDHome(state, payload) {
    state.showGEDHome = payload
  },
  setLoadingGEDStatus(state, payload) {
    state.loadingStatus = payload
  },
  setPreviewGEDInfos(state, payload) {
    state.previewInfos = payload
  },
  setGEDSearchStatus(state, payload) {
    state.gedSearchStatus = payload
  },
  resetToRootFolder(state, payload) {
    state.currentUrlParts = []
    state.loadingStatus = false

    if (state.fullGedCustom.cardsDisplay) {
      state.currentFolder = null
      state.showGEDHome = true
    } else {
      state.currentFolder = state.rootData[0]
    }
  },
  setFullGedCustom(state, payload) {
    state.fullGedCustom = payload
  },
  setFullGEDContentsOptions(state, payload) {
    state.fullGEDContentsOptions = payload
  }
}

export default {
  state,
  getters,
  mutations
}
