import DashboardListingContainer from '../components/dashboard/folders/DashboardListingContainer'
import { fetchFolderData } from '../components/dashboard/folders'

import BrandFormPage from '../pages/BrandFormPage'
import { fetchBrandForm } from '../components/brand-forms/brandForm'

import GedPageCustom from '../pages/GedPageCustom'
import { fetchGedFolder } from '../fetch'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import AdminAdvancedSettingsIdentityPage from '../pages/advanced-settings/AdminAdvancedSettingsIdentityPage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

import dashboardAccess from '../guards/dashboard-access.js'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: {
      disabled: false,
      content: 'pages'
    }
  },
  {
    path: '/brands',
    name: 'Brands',
    component: () => import('../components/brand/BrandSelection'),
    meta: { logout: true }
  },
  {
    path: {
      fr: '/panier',
      en: '/cart'
    },
    name: 'Cart',
    component: () => import('../pages/CartPage')
  },
  {
    path: {
      fr: '/favoris',
      en: '/bookmarks'
    },
    name: 'Bookmarks',
    component: () => import('../pages/BookmarkPage')
  },
  {
    path: {
      fr: '/tableau-de-bord',
      en: '/dashboard'
    },
    name: 'DashboardSummary',
    component: () => import('../pages/DashboardSummaryPage'),
    beforeEnter: (to, from, next) => dashboardAccess({ next })
  },
  {
    path: {
      fr: '/tableau-de-bord-sops-1',
      en: '/dashboard-sops'
    },
    name: 'DashboardListingSops',
    component: withFetch(DashboardListingContainer, { size: 'xxl' })(
      fetchFolderData
    )
  },
  {
    path: {
      fr: '/tableau-de-bord-la-marque',
      en: '/dashboard-the-brand'
    },
    name: 'DashboardListingBrand',
    component: withFetch(DashboardListingContainer, { size: 'xxl' })(
      fetchFolderData
    )
  },
  {
    path: {
      fr: '/tableau-de-bord-archives-marketing-1',
      en: '/dashboard-archives-marketing'
    },
    name: 'DashboardListingArchives',
    component: withFetch(DashboardListingContainer, { size: 'xxl' })(
      fetchFolderData
    )
  },
  {
    path: {
      fr: '/tableau-de-bord/liste/a-valider',
      en: '/dashboard/list/to-validate'
    },
    name: 'DashboardListingToValidate',
    component: () => import('../pages/DashboardListingToValidatePage'),
    beforeEnter: (to, from, next) => dashboardAccess({ next })
  },
  {
    path: {
      fr: '/tableau-de-bord/liste/procedure-corporate',
      en: '/dashboard/list/corporate-procedure'
    },
    name: 'DashboardListingProcedures',
    component: () => import('../pages/DashboardListingProcedures')
  },
  {
    path: {
      fr: '/edition-multiple',
      en: '/multiple-edit'
    },
    name: 'BulkEdition',
    component: () => import('../pages/BulkEditionPage'),
    beforeEnter: (to, from, next) => dashboardAccess({ next })
  },
  {
    path: '/louvre-hotels-group',
    name: 'LHGPage',
    component: () => import('../pages/LhgGroupPage')
  },
  {
    path: '/louvre-hotels-group/:slug',
    name: 'ProcedureModal',
    component: () => import('../components/ged/modals/GedModal'),
    meta: { content: 'procedures' }
  },
  {
    path: {
      fr: '/recherche',
      en: '/search'
    },
    name: 'SolrSearchesPage',
    component: () => import('../pages/SolrSearchesPage')
  },
  {
    name: 'GlobalSearchPage',
    meta: { disabled: true }
  },
  {
    path: '/brand-form/:slug',
    name: 'BrandFormPage',
    component: withFetch(BrandFormPage, { size: 'xxl', watch: true })(
      fetchBrandForm
    ),
    meta: {
      content: 'brand_forms'
    }
  },
  {
    path: '/:folder/:subFolder?',
    name: 'GedPageCustom',
    meta: { content: 'folders', translationParams: ['folder', 'subFolder'] },
    component: withFetch(GedPageCustom, { size: 'xxl', watch: true })(
      fetchGedFolder
    )
  },
  {
    path: '/:folder/:subFolder?/:document',
    name: 'ModalDocument',
    component: () => import('../components/ged/modals/GedModal'),
    meta: {
      content: 'declined_documents,documents,sops,rops,photo,folders',
      translationParams: ['folder', 'subFolder', 'document']
    }
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminAdvancedSettingsIdentityPage',
    component: withFetch(AdminAdvancedSettingsIdentityPage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminAdvancedSettingsAdminMailingsPage',
    meta: { admin: true, disabled: true }
  },
  {
    name: 'AdminAdvancedSettingsArtificialIntelligencePage',
    meta: { admin: true, display: true }
  }
]
