import { http } from '@inside-library/helpers/Http'

export const fetchGedFolder = async ({ $route }) => {
  try {
    const { data: parent } = await http.get('content/folders', {
      fields: ['title', 'uuid', 'machine_name', 'slug'],
      filters: { 'slug:eq': $route.params.folder }
    })

    const { data: folders } = await http.get('content/folders', {
      fields: [
        'title',
        'created_at',
        'langcode',
        'uuid',
        'slug',
        'count',
        'content_type',
        'tree',
        'pid',
        'status',
        'is_media_folder',
        'color',
        'image',
        'uuid',
        {
          'folders.folders': {
            fields: ['uuid', 'title', 'created_at', 'slug'],
            filters: { sort: 'title:asc', alias: 'folders', reverse: true }
          }
        }
      ],
      filters: { 'pid:eq': parent[0].uuid, sort: 'weight:asc' }
    })

    return { folders, parent }
  } catch (err) {
    throw new Error(err)
  }
}
