import { getSpecificPage } from '@inside-library/helpers/ContentConfHelper.js'
import { getMixins } from '@inside-core/helpers/fileGetter'

import DownloadFileMixin from '@inside-library/mixins/download-file-mixin'

let mixins = {}
getMixins().then((res => {
  mixins = res
}))

export default {
  mixins: [mixins['search-actions'] || {}, DownloadFileMixin],
  methods: {
    /*
     * Dispatch action depending on item type
     *
     * @param {object} item
     * @param {number} index
     */
    clickAction(item, index) {
      for (const action in this.actions) {
        if (item.type && item.type === action) {
          this.actions[action](item, index)
        } else if (item.content_type && item.content_type === action) {
          this.actions[action](item, index)
        }
      }
    },
    /*
     * Open external link in a new tab
     *
     * @param {object} item
     */
    externalDocumentsAction(item) {
      window.open(item.link, '_blank')
    },
    /*
     * Manage tools search result by opening a modal or a link
     *
     * @param {object} item
     */
    toolAction(item) {
      if (item.content) {
        this.triggerModal(
          'tools',
          'static',
          { item },
          { layout: 'right', width: 450, transition: 'fadeInLeft' }
        )
      } else {
        this.redirectAction(item)
      }
    },
    /*
     * Manage job search result by opening a job modal
     *
     * @param {object} item
     */
    jobAction(item) {
      this.triggerModal(
        'job-board',
        'fetch',
        { item: item },
        { layout: 'right', transition: 'fadeInLeft' }
      )
    },
    /*
     * Build GED URL and redirect
     *
     * @param {object} item
     */
    foldersAction(item) {
      const gedURL = getSpecificPage(item.content_type)[this.$_currentLang]
      const url = `/${gedURL}#&ged/${item.uuid}`

      if (this.$route.path.indexOf(gedURL) > -1) {
        /*
         * If router is already on ged URL
         * Allow to fix problem with URL - GED URL is decode only when user enter on the page
         */
        window.location.hash = decodeURIComponent(`&ged/${item.uuid}`)
        window.location.reload()
      } else {
        this.$router.push(url)
      }
    },
    /*
     * Open user modal
     *
     * @param {object} item
     */
    usersAction(item) {
      this.triggerModal(
        'user',
        'fetch',
        { item: item },
        { layout: 'right', transition: 'fadeInLeft', width: 450 }
      )
    },
    /*
     * Redirect to relative content or open external link
     *
     * @param {object} item
     */
    redirectAction(item) {
      if (
        this.isAlive(item, ['link', 'url']) &&
        item.link.url.indexOf('http') > -1
      ) {
        if (item.link.external) {
          window.open(item.link.url, '_blank')
        } else {
          window.location.href = item.link.url
        }
      } else {
        this.$router.push(`/external-url/${item.content_type}/${item.uuid}`)
      }
    }
  }
}
