export default {
  data() {
    return {
      searchableContentTypes: [],
      allowedFilters: []
    }
  },
  mounted() {
    const params = {
      params: {
        langcode: this.$_currentLang
      }
    }

    this.get('searchable', params).then(
      response => {
        this.searchableContentTypes = response.data.filter(filter => {
          if (filter.global) {
            this.allowedFilters.push(filter.type)
            if (this.searchKey === 'main-search') {
              this.queryFilters.push(filter.type)
            }

            this.setStoreAction('setSearchAllowedFilters', this.allowedFilters)
          }

          return this.isAlive(filter, 'global') ? filter.global : true
        })

        if (this.searchKey === 'main-search') {
          // Avoid to set search filters translations if 1st translation exists
          const params = {
            content_type: response.data[0].type,
            langcode: this.$_currentLang
          }

          if (!this.$store.getters.getSearchFilterTranslation(params)) {
            this.setStoreAction('setSearchFiltersTranslations', {
              filters: response.data,
              langcode: this.$_currentLang
            })
          }
        }
      },
      err => {
        this.$_triggerErrorToast({
          text: err
        })
      }
    )
  }
}
