import moment from 'moment'

export default {
  methods: {
    $_isMoreThanSevenDays(date) {
      return moment().diff(moment.unix(date), 'days', true) > 7
    }
  },
  computed: {
    $_date() {
      return this.getCheckedData(
        this.heritedData,
        'updated_at',
        this.heritedData.created_at
      )
    },
    $_dateFormat() {
      const disableDateFromNow = this.getCheckedData(
        this.getFullGedCustom,
        'disableDateFromNow',
        false
      )

      if (disableDateFromNow) return 'L'

      return this.$_isMoreThanSevenDays(this.$_date) ? 'L' : null
    }
  }
}
