import { http } from '@inside-library/helpers/Http'

export const fetchFolderData = async ({ $route, store }) => {
  const contentSlug = $route.path.replace(
    store.getters.getCurrentLang === 'fr'
      ? '/fr/tableau-de-bord-'
      : '/en/dashboard-',
    ''
  )

  try {
    const { data } = await http.get('content/folders', {
      fields: ['title', 'uuid'],
      filters: {
        'slug:eq': contentSlug
      }
    })
    
    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
