import { http } from '@inside-library/helpers/Http'

export const fetchBrandForm = async ({ $route }) => {
  try {
    const { data } = await http.get('content/brand_forms', {
      fields: [
        'title',
        'uuid',
        'published_at',
        'admin',
        'content_type',
        'form_id',
        'introduction',
        'status',
        'slug'
      ],
      filters: { 'status:eq': 1, 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
