<?php

namespace Inside\BCLH\Listeners;

use Illuminate\Support\Facades\Queue;
use Inside\BCLH\Jobs\GenerateAlbumZip;
use Inside\BCLH\Jobs\GeneratePdf;
use Inside\Content\Listeners\ContentFullySavedWithImagesListener;
use Inside\Content\Models\Content;
use Inside\Content\Models\Contents\Photo;

class GenerateContentPdf extends ContentFullySavedWithImagesListener
{
    public function handleContent(Content $content): void
    {
        if ($content instanceof Photo) {
            $folder = $content->folders->first();
            Queue::push(new GenerateAlbumZip($folder->uuid));
        }
        /** @var string $uuid */
        $uuid = $content->uuid;
        Queue::push(new GeneratePdf($content->content_type, $uuid, true));
    }

    protected function checkContent(Content $content): bool
    {
        return in_array(
            $content->content_type,
            ['folders', 'sops', 'rops', 'documents', 'declined_documents', 'pages', 'procedures', 'photo']
        );
    }
}
