<?php

namespace Inside\BCLH\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Authentication\Models\User;
use Inside\BCLH\Events\BulkCSVImportedEvent;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;

class BulkCSVImportedListener extends BaseNotificationListener implements ShouldQueue
{
    public function handle(BulkCSVImportedEvent $event): void
    {
        $user = User::query()->find($event->uuid);

        if (! $user instanceof User) {
            return;
        }

        /** @var \Inside\Notify\Models\NotificationType[] $types */
        $types = NotificationType::where('action', 'bulkCSV-import')->get();

        foreach ($types as $type) {
            $this->when = $this->getInterval($type);
            $this->route = $user;
            $this->notify(
                $type,
                $user,
                null,
                [
                    'impactedDocuments' => $event->impactedDocuments,
                ]
            );
        }
    }
}
