<?php

namespace Inside\BCLH\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Storage;
use Inside\Authentication\Models\User;
use Inside\BCLH\Events\BulkCSVExportFailedEvent;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;

class BulkCSVExportFailedListener extends BaseNotificationListener implements ShouldQueue
{
    public function handle(BulkCSVExportFailedEvent $event): void
    {
        $user = User::query()->find($event->uuid);

        if (! $user instanceof User) {
            return;
        }

        /** @var \Inside\Notify\Models\NotificationType[] $types */
        $types = NotificationType::where('action', 'bulkCSV-export-failed')->get();

        foreach ($types as $type) {
            $this->when = $this->getInterval($type);
            $this->route = $user;
            $this->notify(
                $type,
                $user,
                null,
                [
                    'extra' => [
                        'link' => Storage::disk('protected')->url($event->filePath),
                    ],
                ]
            );
        }
    }
}
