<?php

namespace Inside\BCLH\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Storage;
use Inside\Authentication\Models\User;
use Inside\BCLH\Events\BasketGeneratedEvent;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;

/**
 * Test email created listener
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class BasketGeneratedListener extends BaseNotificationListener implements ShouldQueue
{
    public function handle(BasketGeneratedEvent $event): void
    {
        $subscriber = User::query()->find($event->uuid);

        if (! $subscriber instanceof User) {
            return;
        }

        /** @var \Inside\Notify\Models\NotificationType[] $types */
        $types = NotificationType::where('action', 'basket')->get();

        foreach ($types as $type) {
            $this->when = $this->getInterval($type);
            $this->route = $subscriber;
            $this->notify($type, $subscriber, null, ['extra' => ['link' => Storage::disk('protected')->url('basket/'.$event->uuid.'.zip')]]);
        }
    }
}
