<?php

declare(strict_types=1);

namespace Inside\BCLH\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Str;
use Inside\BCLH\Events\EbookGeneratedEvent;
use Inside\BCLH\Facades\Pdf;
use Inside\BCLH\Services\PdfService;
use Inside\Content\Models\Contents\DeclinedDocuments;
use Inside\Content\Models\Contents\Documents;
use Inside\Content\Models\Contents\Folders;
use Inside\Content\Models\Contents\Rops;
use Inside\Content\Models\Contents\Sops;
use Inside\Permission\Facades\Permission;

final class GeneratePdf implements ShouldQueue
{
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    /**
     * @var string
     */
    protected $contentType;

    /**
     * @var string
     */
    protected $uuid;

    /**
     * @var bool
     */
    protected $update;

    public function __construct(string $contentType, string $uuid, bool $update = false)
    {
        $this->contentType = $contentType;
        $this->uuid = $uuid;
        $this->update = $update;
    }

    public function handle(): void
    {
        $query = call_user_func(type_to_class($this->contentType).'::withoutGlobalScopes');
        $content = $query->where('uuid', $this->uuid)->first();

        if ($content) {
            Permission::disableAllowedScope();
            Pdf::generatePdf($this->contentType, $this->uuid, $this->update);
        }

        $this->delete();
    }
}
