<?php

namespace Inside\BCLH\Http\Requests;

use Inside\Http\Requests\FormRequest;

class SopExportRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'filters' => ['nullable', 'json'],
            'fields' => ['required', 'json'],
        ];
    }

    protected function prepareForValidation()
    {
        $filters = $this->input('filters');

        if (is_string($filters)) {
            $decodedFilters = json_decode($filters, true);
            if (is_array($decodedFilters)) {
                $decodedFilters['status:eq'] = 1;
                $this->merge(['filters' => json_encode($decodedFilters)]);
            }
        }

        if (! $this->has('fields')) {
            $this->merge([
                'fields' => json_encode(['uuid', 'content_type']),
            ]);
        }
    }
}
