<?php

namespace Inside\BCLH\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\BCLH\Exceptions\SopImportException;
use Inside\BCLH\Services\ExcelImporterService;

/**
 * Import SOP from excel file
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class SopImportController
{
    public function __construct(private ExcelImporterService $excelImporterService)
    {
    }

    public function invoke(Request $request): JsonResponse
    {
        $response = ['success' => true];
        $filePath = $request->get('file');

        try {
            $this->excelImporterService
                ->setFile($filePath)
                ->execute();
        } catch (SopImportException $exception) {
            $response['success'] = false;
        }

        return response()->json($response);
    }
}
