<?php

namespace Inside\BCLH\Exports;

use Inside\BCLH\Jobs\ExportInExcel;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;

class FailedSopsExport implements FromArray, WithHeadings
{
    use Exportable;

    private const EXCEL_HEADER = [
        'uuid_host',
        'content_type',
        'title',
        'brands',
        'countries',
        'management_modes',
        'profiles',
        'contact',
        'folder',
        'parent',
        'reason',
    ];

    private array $data;

    public function __construct(array $data)
    {
        $this->data = $data;
    }

    public function array(): array
    {
        return $this->data;
    }

    public function headings(): array
    {
        return self::EXCEL_HEADER;
    }
}
