<?php

namespace Inside\BCLH\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;

class BulkCSVImportedEvent implements ShouldBroadcast
{
    use InteractsWithSockets;
    use SerializesModels;

    /**
     * @var string
     */
    public $uuid;

    /**
     * @var int
     */
    public $impactedDocuments;

    public function __construct(string $uuid, int $impactedDocuments)
    {
        $this->uuid = $uuid;
        $this->impactedDocuments = $impactedDocuments;
    }

    public function broadcastOn(): Channel
    {
        return new Channel('inside_bclh_ebook');
    }
}
