<?php

namespace Inside\BCLH\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;

class BulkCSVImportFailedEvent implements ShouldBroadcast
{
    use InteractsWithSockets;
    use SerializesModels;

    /**
     * @var string
     */
    public $uuid;

    public function __construct(string $uuid)
    {
        $this->uuid = $uuid;
    }

    public function broadcastOn(): Channel
    {
        return new Channel('inside_bclh_ebook');
    }
}
