<?php

namespace Inside\BCLH\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;

class BulkCSVExportFailedEvent implements ShouldBroadcast
{
    use InteractsWithSockets;
    use SerializesModels;

    public string $uuid;

    public string $filePath;

    public function __construct(string $uuid, string $filePath)
    {
        $this->uuid = $uuid;
        $this->filePath = $filePath;
    }

    public function broadcastOn(): Channel
    {
        return new Channel('inside_bclh_ebook');
    }
}
