<?php

namespace Inside\BCLH\Console;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Inside\BCLH\Jobs\GenerateAlbumZip;
use Inside\BCLH\Services\PdfService;
use Inside\Content\Models\Contents\Folders;
use Inside\Content\Models\Contents\Photo;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Services\DrupalService;
use Inside\Permission\Models\PermissionSchema;
use Inside\Permission\Models\Role;
use Inside\Permission\Models\RoleCategory;
use Inside\Permission\Models\User;
use Log;
use ZipArchive;

class GenerateAlbumsCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'bclh:albums';

    /*
   * @var string
   */
    protected $signature = 'bclh:albums {--uuid=}';

    /**
     * @var string
     */
    protected $description = 'Generate all albums';

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Import users
     */
    public function handle(): void
    {
        $zipBaseFolder = env('APP_STORAGE_PATH').'/protected/albums/';

        if (! is_dir($zipBaseFolder)) {
            mkdir($zipBaseFolder);
        }

        $uuid = $this->option('uuid');

        if ($uuid) {
            $folders = Folders::query()->where('uuid', $uuid)->get();
        } else {
            $folders = Folders::query()->where('is_media_folder', 1)->get();
        }

        foreach ($folders as $folder) {
            $job = new GenerateAlbumZip($folder->uuid);
            $job->handle();
        }
    }
}
