<!doctype html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
    <title>Ebook</title>
    @include('styles')
</head>
<body>
@include('header')
@include('footer', ['title' => 'Sommaire'])
<section id="summary">
    <h2>{{ \Illuminate\Support\Facades\Lang::getFromJson('bclh.pdf.summary', [], $langcode) }}</h2>

    <ul>
        @foreach($folders as $folder)
            @if($folder['type'] === 'folder' && $folder['hasSops'])
                <li>{{$folder['title']}}
                    @if(isset($folder['children']))
                        <ul>
                            @foreach($folder['children'] as $child)
                                @if($child['type'] === 'folder' && $child['hasSops'])
                                    <li>{{$child['title']}}</li>
                                @endif
                            @endforeach
                        </ul>
                    @endif
                </li>
            @endif
        @endforeach
    </ul>
</section>
</body>
</html>
