@foreach($contents as $content)
  @if (in_array($content['type'], ['text', 'image']))
    <div class="wysiwyg">
      {!! $content['body'] !!}
    </div>
  @elseif($content['type'] === 'accordion')
      <div class="wysiwyg">
          <ul>
              <li class="question">
                  {{ $content['question'] }}
              </li>
              <li class="answer">
                  <div class="wysiwyg">
                      {!! $content['answer'] !!}
                  </div></li>
          </ul>
      </div>
  @elseif($content['type'] === 'text_with_image')
    @if ($content['display'] === 'center')
      <div class="wysiwyg">
        {!! $content['image'] !!}
      </div>
      <div class="wysiwyg">
        {!! $content['body'] !!}
      </div>
    @elseif ($content['display'] === 'left')
      <table class="section">
        <tr>
          <td width="40%">
            <div class="wysiwyg">
              {!! $content['image'] !!}
            </div>
          </td>
          <td>
            <div class="wysiwyg right">
              {!! $content['body'] !!}
            </div>
          </td>
        </tr>
      </table>
    @else
      <table class="section">
        <tr>
          <td>
            <div class="wysiwyg left">
              {!! $content['body'] !!}
            </div>
          </td>
          <td width="40%">
            <div class="wysiwyg">
              {!! $content['image'] !!}
            </div>
          </td>
        </tr>
      </table>
    @endif
  @elseif($content['type'] === 'steps')
    <div class="spacer"></div>
    @foreach($content['steps'] as $step)
      <div class="step">
        @if ($step['position'] === 'left')
          <div class="image">
            <div class="content">
              <img src="{{ $step['image'] }}" alt="{{ $step['title'] }}">
            </div>
          </div>
          <div class="text">
            <div class="content">
              <h3>{{ $step['title'] }}</h3>
              @if (!empty($step['body']))
                {!! $step['body'] !!}
              @endif
            </div>
          </div>
        @else
          <div class="text">
            <div class="content">
              <h3>{{ $step['title'] }}</h3>
              @if (!empty($step['body']))
                {!! $step['body'] !!}
              @endif
            </div>
          </div>
          <div class="image right">
            <div class="content">
              <img src="{{ $step['image'] }}" alt="{{ $step['title'] }}">
            </div>
          </div>
        @endif
      </div>
    @endforeach
  @endif
@endforeach
