<?php

namespace Inside\BCLH\Seeders;

use Illuminate\Database\Seeder;
use Inside\Notify\Models\NotificationType;

class BCLHNotificationsSeeder extends Seeder
{
    public function run(): void
    {
        $notificationTypes = [];

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\BCLH\Events\EbookGeneratedEvent',
                'model' => '',
                'action' => 'ebook',
                'condition' => '',
                'multiple' => false,
                'language' => true,
                'profile' => false,
                'data' => [
                    'title' => 'notifications.ebook.title',
                    'description' => 'notifications.ebook.description',
                    'icon' => 'ebook',
                    'text' => 'notifications.ebook.text',
                ],
            ]
        )->first();

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\BCLH\Events\BasketGeneratedEvent',
                'model' => '',
                'action' => 'basket',
                'condition' => '',
                'multiple' => false,
                'language' => true,
                'profile' => false,
                'data' => [
                    'title' => 'notifications.basket.title',
                    'description' => 'notifications.basket.description',
                    'icon' => 'basket',
                    'text' => 'notifications.basket.text',
                ],
            ]
        )->first();

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => '',
                'model' => '',
                'action' => 'ropCreated',
                'condition' => '',
                'multiple' => false,
                'language' => true,
                'profile' => false,
                'data' => [
                    'title' => 'notifications.ropCreated.title',
                    'description' => 'notifications.ropCreated.description',
                    'icon' => 'ropCreated',
                    'text' => 'notifications.ropCreated.text',
                ],
            ]
        )->first();

        /*        $notificationTypes[] = NotificationType::firstOrCreate(
                    [
                        'via'       => 'web',
                        'default'   => true,
                        'event'     => '',
                        'model'     => '',
                        'action'    => 'declinedDocumentCreated',
                        'condition' => '',
                        'multiple'  => false,
                        'language'  => true,
                        'profile'   => false,
                        'data'      => [
                            'title'       => 'notifications.declinedDocumentCreated.title',
                            'description' => 'notifications.declinedDocumentCreated.description',
                            'icon'        => 'declinedDocumentCreated',
                            'text'        => 'notifications.declinedDocumentCreated.text',
                        ]
                    ]
                )->first();*/

        /* NotificationType::where([
            'type'  => 'workflow',
            'via' => 'email'
        ])->delete();

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via'       => 'email',
                'type'      => 'workflow',
                'default'   => true,
                'event'     => 'Inside\Workflow\Events\ProposalEdited',
                'model'     => 'Inside\Workflow\Models\Proposal',
                'action'    => 'edit',
                'condition' => '',
                'multiple'  => false,
                'language'  => false,
                'profile'   => false,
                'data' => [
                    'title' => 'notifications.workflow.proposals.edited.title',
                    'description' => 'notifications.workflow.proposals.edited.description',
                    'url' => 'CUSTOM:bclh_ged',
                    'mail' => [
                        'subject' => 'notifications.workflow.proposals.edited.mail.subject',
                        'text' => 'notifications.workflow.proposals.edited.mail.content',
                        'buttonText' => 'notifications.custom.report.documents.mail.buttonText'
                    ]
                ]
            ]
        )->first();

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via'       => 'email',
                'type'      => 'workflow',
                'default'   => true,
                'event'     => 'Inside\Workflow\Events\ProposalReviewed',
                'model'     => 'Inside\Workflow\Models\Proposal',
                'action'    => 'accept',
                'condition' => '',
                'multiple'  => false,
                'language'  => false,
                'profile'   => false,
                'data' => [
                    'title' => 'notifications.workflow.proposals.accepted.title',
                    'description' => 'notifications.workflow.proposals.accepted.description',
                    'url' => 'CUSTOM:bclh_ged',
                    'mail' => [
                        'subject' => 'notifications.workflow.proposals.accepted.mail.subject',
                        'text' => 'notifications.workflow.proposals.accepted.mail.content',
                        'buttonText' => 'notifications.custom.report.documents.mail.buttonText'
                    ]
                ]
            ]
        )->first();

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via'       => 'email',
                'type'      => 'workflow',
                'default'   => true,
                'event'     => 'Inside\Workflow\Events\ProposalReviewed',
                'model'     => 'Inside\Workflow\Models\Proposal',
                'action'    => 'decline',
                'condition' => '',
                'multiple'  => false,
                'language'  => false,
                'profile'   => false,
                'data' => [
                    'title' => 'notifications.workflow.proposals.declined.title',
                    'description' => 'notifications.workflow.proposals.declined.description',
                    'url' => 'CUSTOM:bclh_ged',
                    'mail' => [
                        'subject' => 'notifications.workflow.proposals.declined.mail.subject',
                        'text' => 'notifications.workflow.proposals.declined.mail.content',
                        'buttonText' => 'notifications.custom.report.documents.mail.buttonText'
                    ]
                ]
            ]
        )->first();

        $this->command->info('Notifications created, no subscribers'); */
    }
}
